import type { HtmlTagDescriptor } from 'vite'

// declare global {
//   interface Window {
//     Tally: {
//       loadEmbeds: () => void,
//       closePopup: (formId: string) => void,
//       openPopup: (
//         formId: string,
//         options?: {
//           key?: string; // This is used as a unique identifier used for the "Show only once" and "Don't show after submit" functionality
//           layout?: 'default' | 'modal';
//           width?: number;
//           alignLeft?: boolean;
//           hideTitle?: boolean;
//           overlay?: boolean;
//           emoji?: {
//             text: string;
//             animation: 'none' | 'wave' | 'tada' | 'heart-beat' | 'spin' | 'flash' | 'bounce' | 'rubber-band' | 'head-shake';
//           };
//           autoClose?: number; // in milliseconds
//           showOnce?: boolean;
//           doNotShowAfterSubmit?: boolean;
//           customFormUrl?: string; // when you want to load the form via it's custom domain URL
//           hiddenFields?: {
//             [key: string]: unknown,
//           };
//           onOpen?: () => void;
//           onClose?: () => void;
//           onPageView?: (page: number) => void;
//           // onSubmit?: (payload: SubmissionPayload) => void;
//         }
//       ) => void
//     }
//   }
// }
//
type TallySoProperty = boolean

type TallySoMainProperty = TallySoProperty & {
  injectTo?: HtmlTagDescriptor['injectTo']
}

export type TallySoOptions = TallySoMainProperty

const TALLY_SO_HEAD_SCRIPT_SRC = 'https://tally.so/widgets/embed.js'

function injectTag(options: TallySoOptions): HtmlTagDescriptor[] {
  const tags: HtmlTagDescriptor[] = []

  if (!options) {
    return tags
  }

  tags.push({
    tag: 'script',
    attrs: {
      src: TALLY_SO_HEAD_SCRIPT_SRC,
    },
    injectTo: options.injectTo,
  })

  return tags
}
export default injectTag
